package conversions;
import java.awt.*;

public class MomentQuantity extends ObservableQuantity {
	
	private double value;
	private int type;

	private String units = "in-lb";

	private boolean metric = false;
	private String name = "";
	
	public boolean isMetric() {
		return metric;
	}
	
	public MomentQuantity(
		double _value, 
		String _name,
		int _type) {
		value = _value;
		name = _name;
		type=_type;
	}
	public int getType() {
		return type;
	}
	public double getValue() {
		return value;
	}
	
	
	public void setValue(double d) {
		convertToEnglish();
		if (value == d) return;
		value = d;
		setChanged();	
	}

	
	public String getUnits() {
		return units;
	}
	public void convertToMetric() {
		if (metric == true) return;
		setChanged();
		setChanged();
		metric = true;
		units = "N-mm";
		value =
			value * 112.979;
	}
	public String toString() {
		return name+"=" + value + " "+units;
	}
	public void convertToEnglish() {
		if (metric == false) return;
		setChanged();

		metric = false;
		units = "inches";
		value =
			value /112.979;
	}
	
	
	public  void test() {

		System.out.println(this );
		convertToEnglish();
		System.out.println(this );
		convertToMetric();
		System.out.println(this);
	}		
 
		
}